﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.OleDb;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Brian_LaRue
{
    public partial class FilterCoins : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                string connString = @"PROVIDER=Microsoft.ACE.OLEDB.12.0;" + @"DATA SOURCE=" + Path.Combine(AppDomain.CurrentDomain.BaseDirectory + "App_Data", "CoinsDB.accdb");
                using (OleDbConnection connection = new OleDbConnection(connString))
                {
                    connection.Open();
                    OleDbDataReader reader = null;
                    OleDbCommand command = new OleDbCommand("SELECT * from  Coin", connection);
                    reader = command.ExecuteReader();
                    DataTable dt = new DataTable();
                    dt.Load(reader);

                    if (dt.Rows.Count > 0)
                    {
                        gvFilteredCoins.DataSource = dt;
                        gvFilteredCoins.DataBind();
                        connection.Close();
                        lblMessage.Text = "";
                    }
                    else
                    {
                        lblMessage.Text = "No data to display.";
                        gvFilteredCoins.DataSource = null;
                        gvFilteredCoins.DataBind();
                    }
                }
            }
        }

        /// <summary>
        /// This method converts the list to DataTable
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        static DataTable ToDataTable(List<DataRow> rows)
        {
            DataTable table = new DataTable();
            table.Columns.Add("CoinName");
            table.Columns.Add("Weight");
            table.Columns.Add("Color");
            table.Columns.Add("Diameter");
            table.Columns.Add("Thickness");
            table.Columns.Add("DateOfInsert");

            foreach (var row in rows)
            {
                table.Rows.Add(row.ItemArray);
            }

            return table;
        }

        protected void btnFilter_Click(object sender, EventArgs e)
        {
            string op = ddlOperator.SelectedValue;
            if(txtWeight.Text.Trim()=="")
            {
                lblMessage.Text = "Please enter the Weight for Criteria";
                return;
            }
            else
            {
                lblMessage.Text = "";
            }

            double weight = Convert.ToDouble(txtWeight.Text);

            string connString = @"PROVIDER=Microsoft.ACE.OLEDB.12.0;" + @"DATA SOURCE=" + Path.Combine(AppDomain.CurrentDomain.BaseDirectory + "App_Data", "CoinsDB.accdb");
            using (OleDbConnection connection = new OleDbConnection(connString))
            {
                connection.Open();
                OleDbDataReader reader = null;
                OleDbCommand command = new OleDbCommand("SELECT * from  Coin", connection);
                reader = command.ExecuteReader();
                DataTable dt = new DataTable();
                dt.Load(reader);
                List<DataRow> dr = dt.AsEnumerable().ToList();

                // Use Linq to filter the datatable as per the user's choice
                if (op == "0")
                {
                    dr = dr.Where(t => Convert.ToDouble(t["Weight"].ToString()) == weight).ToList();
                }
                else if(op=="1")
                {
                    dr = dr.Where(t => Convert.ToDouble(t["Weight"].ToString()) > weight).ToList();
                }
                else
                {
                    dr = dr.Where(t => Convert.ToDouble(t["Weight"].ToString()) < weight).ToList();
                }

                DataTable filteredDT = ToDataTable(dr);

                if (filteredDT.Rows.Count > 0)
                {
                    gvFilteredCoins.DataSource = filteredDT;
                    gvFilteredCoins.DataBind();
                    connection.Close();
                    lblMessage.Text = "";
                }
                else
                {
                    lblMessage.Text = "No data to display.";
                    gvFilteredCoins.DataSource = null;
                    gvFilteredCoins.DataBind();
                }
            }
        }
    }
}